% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{simulate_bites}
\alias{simulate_bites}
\title{Simulate bites}
\usage{
simulate_bites(
  no.of.bites = 5,
  length.of.bite = 1000,
  length.of.series = 10000,
  max.y = 1,
  max.y.jit = NULL,
  peak.pos = 50,
  slope.perc.start = 10,
  slope.perc.end = slope.perc.start,
  jit = NULL,
  bite.type = "sin",
  plot = TRUE
)
}
\arguments{
\item{no.of.bites}{Number of bites in time series. Default: \code{5}.}

\item{length.of.bite}{Length of each bite. Default: \code{1000}.}

\item{length.of.series}{Length of the whole time series. Default: \code{10000}.}

\item{max.y}{Maximum y value. Default: \code{1}.}

\item{max.y.jit}{Jitter above and below maximum y value in \verb{[\%]} of maximum y value. Default: \code{NULL}.}

\item{peak.pos}{Position (in percent) of peak within peak curve.
Only applies to \verb{bite.type = "sin} (sinusoidal bites.) Default: same as \code{50}.}

\item{slope.perc.start}{Percentage of how much of the whole bite is defined by the ascending slope.
Only applies to \verb{bite.type = "plat} (plateau-like bites.) Default: \code{10}.}

\item{slope.perc.end}{Percentage of how much of the whole bite is defined by the descending slope.
Only applies to \verb{bite.type = "plat} (plateau-like bites.) Default: same as \code{slope.perc.start}.}

\item{jit}{Jitter along the whole time series. Default: \code{NULL}.}

\item{bite.type}{String: either "sin" or "plat" for sinusoidal or plateau-like bites, respectively. Default: \code{"sin"}.}

\item{plot}{Logical. If \code{TRUE}, the simulated time series will be plotted to the active plot device. Default: \code{TRUE}.}
}
\value{
Returns a tibble with the columns \code{t} and \code{y} containing simulated bites.
}
\description{
Simulates either sinusoidal or plateau-like bites.
}
\examples{
# simulate a time series with sinusoidal bites
# where the peaks are located in the centers of the bites.
simulate_bites(no.of.bites = 5,
                length.of.bite = 1000,
                length.of.series = 10000,
                max.y = 5,
                max.y.jit = 15,
                jit = 0.5,
                peak.pos = 0.5,
                bite.type = "sin",
                plot = TRUE)

# simulate a time series with sinusoidal bites
# where the peaks are located towards the ends of the bites.
simulate_bites(no.of.bites = 5,
                length.of.bite = 1000,
                length.of.series = 10000,
                max.y = 5,
                max.y.jit = 15,
                jit = 0.5,
                peak.pos = 0.8,
                bite.type = "sin",
                plot = TRUE)

# simulate a time series with plateau-like bites
simulate_bites(no.of.bites = 5,
                length.of.bite = 1000,
                length.of.series = 10000,
                max.y = 5,
                max.y.jit = 15,
                jit = 1,
                bite.type = "plat",
                plot = TRUE)

# simulate a time series with plateau-like bites
# with slowly ascending bite start and abprupt bite end.
simulate_bites(no.of.bites = 5,
                length.of.bite = 1000,
                length.of.series = 10000,
                max.y = 5,
                max.y.jit = 15,
                slope.perc.start = 60,
                slope.perc.end = 10,
                jit = 1,
                bite.type = "plat",
                plot = TRUE)
}
