% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_series_manipulations.R
\name{y_to_force}
\alias{y_to_force}
\title{Convert Time Series to Force}
\usage{
y_to_force(df, classifier, measurement.col)
}
\arguments{
\item{df}{Data frame or tibble in the below mentioned format. This should contain the time series, with
one line per time step and measurement.}

\item{classifier}{Classifier in the below mentioned format.}

\item{measurement.col}{Character string. If \code{measurement.col} is not defined, the whole input data frames will be
treated as if it was just one single time series. This is okay for data frames like that indeed only contain one
time series, but for data frames
with multiple time series, a grouping column needs to be defined. Default: \code{NULL}}
}
\value{
Returns a tibble in the same format as the input tibble with an additional column called '"'\code{force}'.
}
\description{
Converts a time series, e.g. a continuous voltage measurement from a sensor to force data
according to an amplification value and, depending on the measurement setup, the lever ratio of the
rocker forwarding the force from the point the force acts on to the sensor.
}
\details{
These values should be stored in a \code{classifier} (s. below). At the same, it adds \code{specimen} and \code{species}
info from the respective columns of the \code{classifier}.

The \code{classifier} should have the following format:\tabular{ccccc}{
   \strong{\code{species}} \tab \strong{\code{specimen}} \tab \strong{\code{measurement}} \tab \strong{\code{amp}} \tab \strong{\code{lever.ratio}} \cr
   \code{species.1} \tab \code{specimen.1} \tab \code{measurement.1} \tab \code{amp.1} \tab \code{lever.ratio.1} \cr
   \code{...} \tab \code{...} \tab \code{...} \tab \code{...} \tab \code{...} \cr
   \code{species.n} \tab \code{specimen.n} \tab \code{measurement.n} \tab \code{amp.n} \tab \code{lever.ratio.n} \cr
}


It must contain one row per unique measurement number that is present in the
df.

The force (\code{F}) in Newton is calculated \emph{via} the following formula:

\code{F = y * lever.ratio * (1 / amp)}

where \code{y} is the measurement series, e.g. in \code{V}, \cr
\code{amp} is the amplification value, e.g. in \code{V/N}, \cr
and \code{lever.ratio} is the mechanical lever ratio of the measurement setup.

\code{df} should have the following format:\tabular{ccc}{
   \strong{\code{t}} \tab \strong{\code{y}} \tab \strong{\code{measurement}} \cr
   \code{t.1} \tab \code{y.1} \tab \code{measurement.1} \cr
   \code{t.2} \tab \code{y.2} \tab \code{measurement.1} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{y.n} \tab \code{measurement.1} \cr
   \code{t.1} \tab \code{y.1} \tab \code{measurement.2} \cr
   \code{t.2} \tab \code{y.2} \tab \code{measurement.2} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.m} \tab \code{y.m} \tab \code{measurement.2} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.o} \tab \code{y.o} \tab \code{measurement.o} \cr
}
}
\examples{
# convert y column of df.all to force column and add taxonomic data
# using info from classifier
df.all.tax <- y_to_force(df = forceR::df.all.200,
                      classifier = forceR::classifier,
                      measurement.col = "measurement")

df.all.tax

}
