% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributeCalculator.R
\name{calculateAttributes}
\alias{calculateAttributes}
\title{Calculates the attributes of the hydroclimate time series}
\usage{
calculateAttributes(climateData, attSel, startYr = NULL, endYr = NULL)
}
\arguments{
\item{climateData}{list; reference climate data, with vector \emph{times} in POSIXct format,
and climate variables \emph{*variable_name1*}, \emph{*variable_name2*}. Climate variables are specified as vectors for single-site data, and matrices for multi-site data (with columns for each site). \cr
           Please refer to data provided with the package that may be loaded using \code{data(tankDat)} and \code{data(barossaDat)} for examples of the expected format of single site and multi-site \code{reference}.}

\item{attSel}{a vector; specifying the names of the attributes to be calculated.}

\item{startYr}{a number (default \code{NULL}); to specify the starting year to subset \code{climateData} if required.
If \code{NULL}, \code{startYr} is starting year in the input \code{climateData}.}

\item{endYr}{a number (default \code{NULL}); to specify the ending year to subset \code{climateData} if required.
If \code{NULL}, \code{endYr} is last year in the input \code{climateData}.}
}
\value{
The function returns a vector of attributes with names of the attributes (\code{attSel}).
For multi-site data, names are combinations of attribute and site names.
}
\description{
\code{calculateAttributes} calculates the specified attributes of the input daily hydroclimate time series.
}
\examples{
#----------------------------------------------------------------------
# Example 1: Single-site  input
# load 'tank' example climate data available in the package
data("tankDat")
# specify rainfall and temperature attributes to calculate
attSel <- c(
  "P_day_all_tot_m", "P_day_all_nWet_m", "P_day_all_R10_m",
  "Temp_day_all_rng_m", "Temp_day_all_avg_m"
)
tank_obs_atts <- calculateAttributes(tank_obs, attSel = attSel)
#----------------------------------------------------------------------
# Example 2: Multi-site  input
# load 'Barossa' example climate data available in the package
data("barossaDat")
# specify rainfall attributes to calculate
attSel <- c("P_day_all_tot_m", "P_day_all_nWet_m", "P_day_all_P99")
barossa_obs_atts <- calculateAttributes(barossa_obs, attSel = attSel)
}
