% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forested.R
\docType{data}
\name{forested}
\alias{forested}
\alias{forested_wa}
\alias{forested_ga}
\title{Forest Attributes in the U.S.}
\format{
A data frame with:

\describe{
\item{forested}{Whether the plot is classified as "forested" or not,
as a factor with levels \code{"Yes"} and \code{"No"}.}
\item{year}{Year when the plot was classified "on-the-ground" as forested
or not. The remaining, remotely-sensed variables are measured at
different times or averaged over multiple years.}
\item{elevation}{Elevation, in meters.}
\item{eastness}{Transformed aspect degrees to eastness (-100 to 100).}
\item{northness}{Transformed aspect degrees to northness (-100 to 100).}
\item{roughness}{Degree of irregularity of the plot.}
\item{tree_no_tree}{LANDFIRE tree/non-tree lifeform mask, as a factor
with levels \code{"Tree"} and \code{"No tree"}.}
\item{dew_temp}{Mean annual dewpoint temperature (1991-2020), in degrees
Celsius.}
\item{precip_annual}{Mean annual precipitation (1991-2020), in mm × 100.}
\item{temp_annual_mean}{Mean annual temperature (1991-2020), in degrees
Celsius.}
\item{temp_annual_min}{Mean annual minimum temperature (1991-2020), in
degrees Celsius.}
\item{temp_annual_max}{Mean annual maximum temperature (1991-2020), in
degrees Celsius.}
\item{temp_january_min}{Mean minimum temperature in January (1991-2020), in
degrees Celsius.}
\item{vapor_min, vapor_max}{Minimum and maximum annual vapor pressure
deficit (1991-2020), in Pa x 100.}
\item{canopy_cover}{Analytical Tree Canopy Cover, as a percent.}
\item{lon, lat}{The longitude and latitude of the center of the plot
with a slight perturbation.}
\item{land_type}{Land cover type from European Space Agency (ESA) 2020
WorldCover global land cover product, as a factor with levels
\code{"Tree"}, \code{"Non-tree vegetation"}, and \code{"Barren"}.}
\item{county}{The county in the state, as a factor.}
}

The number of rows varies by state. Washington has 7107 rows,
Georgia has 10937.

The Georgia data has one less column than the Washington data as its
\code{northness} column has been omitted due to issues with the source raster.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 7107 rows and 20 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 10937 rows and 19 columns.
}
\source{
\emph{For more information on the source data, see Table 1 in:}

White, Grayson W.; Yamamoto, Josh K.; Elsyad, Dinan H.;
Schmitt, Julian F.; Korsgaard, Niels H.; Hu, Jie Kate;
Gaines III, George C.; Frescino Tracey S.; McConville, Kelly
S. (2024). Small area estimation of forest biomass via a two-stage
model for continuous zero-inflated data. Forthcoming:
arXiv 2402.03263 (ver. 2.0).

\emph{For more on data definitions:}

Wieczorek, Jerzy A.; White, Grayson W.; Cody, Zachariah W.; Tan, Emily X.;
Chistolini, Jacqueline O.; McConville, Kelly S.; Frescino, Tracey S.;
Moisen, Gretchen G. (2024). Assessing small area estimates via
artificial populations from KBAABB: a kNN-based approximation to ABB.
Forthcoming: arXiv 2306.15607 (ver. 2.0.

\emph{Source data pre-preprocessed using the FIESTA R Package (GPL-3):}

Frescino, Tracey S.; Moisen, Gretchen G.; Patterson, Paul L.; Toney, Chris;
White, Grayson W. (2023). FIESTA: A forest inventory estimation and analysis
R package. Ecography 2023: e06428 (ver. 1.0).
}
\usage{
forested

forested_wa

forested_ga
}
\description{
The U.S. Department of Agriculture, Forest Service, Forest Inventory and
Analysis (FIA) Program provides all sorts of
estimates of forest attributes for uses in research, legislation, and land
management. The FIA uses a set of criteria to classify a plot of land as
"forested" or "non-forested," and that classification is a central data
point in many decision-making contexts. A small subset of plots in
the U.S. are sampled and assessed "on-the-ground" as forested or
non-forested, but the FIA has access to remotely sensed data for all land
in the country. Practitioners can develop a model on the more easily-accessible
remotely sensed data to predict whether a plot is forested or non-forested.
}
\section{Data by state}{


The forested package provides a few data sets, each corresponding to forest
data in one state:
\itemize{
\item \code{forested} corresponds to \strong{Washington} state and is aliased as \code{forested_wa}.
\item \code{forested_ga} corresponds to \strong{Georgia}.
}
}

\examples{
# Washington data:
str(forested)
head(forested)
all.equal(forested, forested_wa)

# Georgia data:
str(forested_ga)
head(forested_ga)
}
\keyword{datasets}
