% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{nlines}
\alias{nlines}
\alias{nlines,list-method}
\alias{nlines,NULL-method}
\alias{nlines,character-method}
\title{Number of lines required to print a value}
\usage{
nlines(x, colwidths = NULL, max_width = NULL, fontspec, col_gap = NULL)

\S4method{nlines}{list}(x, colwidths = NULL, max_width = NULL, fontspec, col_gap = NULL)

\S4method{nlines}{NULL}(x, colwidths = NULL, max_width = NULL, fontspec, col_gap = NULL)

\S4method{nlines}{character}(x, colwidths = NULL, max_width = NULL, fontspec, col_gap = NULL)
}
\arguments{
\item{x}{(\code{ANY})\cr the object to be printed.}

\item{colwidths}{(\code{numeric})\cr column widths (if necessary). Principally used in \code{rtables}'
method.}

\item{max_width}{(\code{numeric(1)})\cr width that strings should be wrapped to when
determining how many lines they require.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{col_gap}{(\code{numeric(1)})\cr width of gap between columns in number of spaces.
Only used by methods which must calculate span widths after wrapping.}
}
\value{
The number of lines needed to render the object \code{x}.
}
\description{
Number of lines required to print a value
}
