% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foto_batch.R
\name{foto_batch}
\alias{foto_batch}
\title{Calculates FOTO classification of texture for an image batch}
\usage{
foto_batch(path, window_size = 61, method = "zones", cores = 1)
}
\arguments{
\item{path}{directory containing (only) image files to process}

\item{window_size}{a moving window size in pixels (default = 61 pixels)}

\item{method}{zones (for discrete zones) or mw for a moving window
approach}

\item{cores}{number of cores to use in parallel calculations}
}
\value{
returns a radial spectrum for a moving window across a
raster layer
}
\description{
This routine process images as a batch, normalizing the PCA
analysis across images. This global normalization makes it possible
to compare the resulting PCA scores across images and infer trends
over different remote sensing tiles or across time.
}
\examples{
\dontrun{
# load demo data path
path <- system.file("extdata", package = "foto")

# classify pixels using zones (discrete steps)
output <- foto_batch(
  path = path,
  window_size = 25,
  method = "zones"
)
}

}
\seealso{
\code{\link[foto]{rspectrum}} \code{\link[foto]{foto}}
}
