% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_metrics.R
\name{auc_metrics}
\alias{auc_metrics}
\title{Calculate Partial and complete Area Under the Curve (AUC) Metrics}
\usage{
auc_metrics(
  test_prediction,
  prediction,
  threshold = 5,
  sample_percentage = 50,
  iterations = 500,
  compute_full_auc = TRUE
)
}
\arguments{
\item{test_prediction}{Numeric vector of test prediction values (e.g., model outputs)}

\item{prediction}{Numeric vector or SpatRaster object containing prediction values}

\item{threshold}{Percentage threshold for partial AUC calculation (default = 5)}

\item{sample_percentage}{Percentage of test data to sample (default = 50)}

\item{iterations}{Number of iterations for estimating bootstrap statistics (default = 500)}

\item{compute_full_auc}{Logical. If TRUE, the complete AUC values will be computed}
}
\value{
A list containing:
\itemize{
  \item If input has no variability: List with NA values for AUC metrics
  \item Otherwise: Matrix of AUC results.
}
}
\description{
Computes partial AUC ratios between model predictions and random curves at a specified threshold,
with options for sampling and iterations. Handles both numeric vectors and SpatRaster inputs.
}
\details{
Partial ROC is calculated following Peterson et al.
(2008; \doi{10.1016/j.ecolmodel.2007.11.008}).
The function calculates partial AUC ratios by:
\enumerate{
  \item Validating input types and completeness
  \item Handling NA values and SpatRaster conversion
  \item Checking for prediction variability
  \item Computing AUC metrics using optimized C++ code
}

When prediction values have no variability (all equal), the function returns NA values with a warning.
}
\examples{
# With numeric vectors
test_data <- rnorm(100)
pred_data <- rnorm(100)
result <- fpROC::auc_metrics(test_prediction = test_data, prediction = pred_data)

# With SpatRaster
library(terra)
r <- terra::rast(ncol=10, nrow=10)
values(r) <- rnorm(terra::ncell(r))
result <- fpROC::auc_metrics(test_prediction = test_data, prediction = r)

}
\references{
Peterson, A.T. et al. (2008) Rethinking receiver operating characteristic analysis applications in ecological niche modeling. Ecol. Modell., 213, 63–72.
}
