% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.frailtyIllnessDeath.R
\name{plot.frailtyIllnessDeath}
\alias{plot.frailtyIllnessDeath}
\title{Plot Method for a Weibull Illness-Death model with optional shared frailty between transitions.}
\usage{
\method{plot}{frailtyIllnessDeath}(x, type.plot = "Baseline hazard", transition,
   conf.bands=TRUE, pos.legend = "topright", cex.legend=0.7, lwd=c(1,1,1), 
   color=2, median=TRUE, Xlab = "Time", Ylab= "Baseline hazard function",...)
}
\arguments{
\item{x}{A Weibull Illness-Death model, i.e. an \code{IllnessDeath} class object
(output from calling \code{IllnessDeath} function).}

\item{type.plot}{a character string specifying the type of curve. Possible
value are "Baseline hazard", or "Baseline survival". The default is "Baseline hazard".
Only the first letters are required, e.g "Haz", "Su".}

\item{transition}{Argument to specify if only the plot of one of the three transitions is wanted. If not specified, the plots
for all transitions are displayed. Possible values are "01", "02" or "12".}

\item{conf.bands}{Logical value. Determines whether confidence bands will be
plotted.  The default is to do so.}

\item{pos.legend}{The location of the legend can be specified by setting
this argument to a single keyword from the list '"bottomright"', '"bottom"',
'"bottomleft"', '"left"', '"topleft"', '"top"', '"topright"', '"right"' and
'"center"'. The default is '"topright"'.}

\item{cex.legend}{character expansion factor *relative* to current
'par("cex")'. Default is 0.7.}

\item{lwd}{A vector of length 3 of positive values to specify the line width of the plots and their
confidence bands. If no confidence bands are plotted, the last two elements of the vector are ignored.
Default is (1,1,1).}

\item{color}{color of the curve (integer).}

\item{median}{Logical value. Determines whether median survival time will be plotted. Default is TRUE.}

\item{Xlab}{Label of x-axis. Default is '"Time"'.}

\item{Ylab}{Label of y-axis. Default is '"Baseline hazard function"'.}

\item{...}{other unused arguments}
}
\value{
Print a plot of a Weibull Illness-Death model with optional shared frailty between transitions.
}
\description{
Plots estimated baseline survival and hazard functions from an object of
  class 'frailtyIllnessDeath'. Confidence bands are allowed.
}
\examples{


  \donttest{

    ###--- Semi-Markovian Weibull Illness-Death model with left truncation ---###

    data(Paq810)

    ModIllnessDeath_SemiMarkov_LeftTrunc <- frailtyIllnessDeath(
      formula = Surv(e, r, dementia) ~ gender + certif,
      formula.terminalEvent = Surv(t, death) ~ gender + certif,
      data = Paq810,
      print.info = FALSE,
      maxit = 100
    )

    plot(ModIllnessDeath_SemiMarkov_LeftTrunc)

    #-- No confidence bands
    plot(ModIllnessDeath_SemiMarkov_LeftTrunc, conf.bands = FALSE)

  }


}
\seealso{
\code{\link{frailtyIllnessDeath}}
}
\keyword{file}
