% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frapprocess.R
\name{frapprocess}
\alias{frapprocess}
\title{Process FRAP data}
\usage{
frapprocess(ds, time_points)
}
\arguments{
\item{ds}{A dataset that contains FRAP data for multiple experiment groups}

\item{time_points}{A vector of time points (in second) that the experiment uses, e.g. 0, 5, 10, ....}
}
\value{
A list of results:
\itemize{
\item $time_points: a vector of time points
\item $summary: summary of the regression
\item $sample_means: a matrix of sample means, nrow = num of time points, ncol = sample size
\item $sample_sd: a matrix of standard deviations, nrow = num of time points, ncol = sample size
\item $model: a list of models for each group from the non-linear regression
\item $details: details of the regression for each group
}
}
\description{
Normalize and analyze FRAP data. Perform non-linear regression and calculate ymax, ymin, k, halftime, tau, total_recovery, total_recovery_sd.
}
\examples{
info <- frapprocess(example_dataset, seq(0, 145, 5))

}
