% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.frbs.R
\name{frbsPMML}
\alias{frbsPMML}
\title{The frbsPMML generator}
\usage{
frbsPMML(model, model.name = "frbs_model", app.name = "frbs",
  description = NULL, copyright = NULL,
  algorithm.name = model$method.type, ...)
}
\arguments{
\item{model}{an frbs model.}

\item{model.name}{a string representing the model name.}

\item{app.name}{a string representing an application name.}

\item{description}{a string representing the simulation description.}

\item{copyright}{a copyright of simulation.}

\item{algorithm.name}{a string representing the algorithm name.}

\item{...}{other parameters}
}
\value{
FRBS model in frbsPMML format
}
\description{
It is the main function used for generating the frbsPMML format. In this package, we provide interfaces for writing and reading frbsPMML to/from a text file. 
See \code{\link{write.frbsPMML}} and \code{\link{read.frbsPMML}}.
}
\details{
frbsPMML is a universal framework for representing FRBS models, which is a format adopted from the Predictive Model Markup Language (PMML). 
PMML is a format constructed by an XML-based language to provide a standard for describing models produced 
by data mining and machine learning algorithms. A main contribution of PMML is 
to provide interoperable schemata of predictive models. 
Using PMML, we can easily perform these tasks as our models are documented
in an XML-based language. Human experts can also update and modify the model on the files directly.

Since PMML is an XML-based language, the specification is defined by an XML Schema as 
recommended by the World Wide Web Consortium (W3C). The PMML format is specified by the main 
tag \emph{PMML} that contains some components. In the following, we describe the main components:
\itemize{
\item \emph{Header}: It contains general information about the PMML document, 
       such as copyright information for the model, its description, application, 
       and timestamp of generation. 
\item \emph{DataDictionary}: It contains information related to fields or variables, 
       such as number, names, types, and value ranges of variables.
\item \emph{MODEL-ELEMENT}: It is a main part of the PMML document that consists of models 
       supported by PMML. In each model, there are several components embedded in the element, 
       such as \emph{MiningSchema} and \emph{Output}. 
       \emph{MiningSchema} specifies outlier treatment, a missing value replacement policy, 
       and missing value treatment, whereas \emph{Output} shows a description of the output variable. 
       For example, in a clustering model, we define a schema representing the cluster centers 
       that are included in the \emph{ClusteringModel} element.       
}
Besides these components, there are some optional elements, such as \emph{MiningBuildTask}, 
\emph{TransformationDictionary}, and \emph{Extension}. 
More detailed information about PMML can be found in (Guazzelli et al., 2009).

Three models, which can be used for handling regression and classification tasks, 
are specified by the proposed representations: Mamdani, Takagi Sugeno Kang, and fuzzy rule-based classification systems. 
There are the following benefits offered by frbsPMML, as follows:
\itemize{
\item Interoperability: It is a standard format for representing many models without 
      depending on any programming languages (e.g., Java, Python, and C++) and platforms (e.g., Windows, Linux, and Mac). 
\item Tranparency: Since it is formed based on XML Schema containing formal definitions of the available elements, we can 
      understand FRBS models as written in frbsPMML.
\item Interpretability: frbsPMML expresses rulebase, database, and inference schema in simple ways. For example, 
      rulebase is constructed recursively, so that besides it meets to the mathematical logic (predicate), we can
      define different operators (i.e., \code{and} and \code{or}) in one rule.  
\item Flexibility: Since frbsPMML is based XML, human experts can easily modify and improve a model in the text file directly. 
\item Reproducibility: Sicen frbsPMML is a universal representation, it allows us to store, share, execute, and reproduce an FRBS model.	
}
}
\examples{
## This example shows how to construct a frbsPMML file of the frbs model
## Even though we are using MAMDANI model, other models have the same way
## 
## 1. Produce frbs model, for example: we perform Wang & Mendel's technique (WM)
## Input data
\dontrun{data(frbsData)
data.train <- frbsData$GasFurnance.dt[1 : 204, ]
data.fit <- data.train[, 1 : 2]
data.tst <- frbsData$GasFurnance.dt[205 : 292, 1 : 2]
real.val <- matrix(frbsData$GasFurnance.dt[205 : 292, 3], ncol = 1)
range.data <- matrix(c(-2.716, 2.834, 45.6, 60.5, 45.6, 60.5), nrow = 2)

## Set the method and its parameters
method.type <- "WM"
control <- list(num.labels = 3, type.mf = "GAUSSIAN", type.defuz = "WAM", 
                type.tnorm = "MIN", type.implication.func = "ZADEH", 
                name = "sim-0") 

## Generate fuzzy model
object <- frbs.learn(data.train, range.data, method.type, control)

## 2. Write frbsPMML file
## by calling frbsPMML(), the frbsPMML format will be displayed in R console
frbsPMML(object)}

}
\references{
A. Guazzelli, M. Zeller, W.C. Lin, and G. Williams., 
"pmml: An open standard for sharing models", The R Journal, Vol. 1, No. 1, pp. 60-65 (2009).

Data Mining Group, http://www.dmg.org/.
}
