% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DenFMean.R
\name{DenFMean}
\alias{DenFMean}
\title{Fréchet means of densities.}
\usage{
DenFMean(yin = NULL, hin = NULL, qin = NULL, optns = list())
}
\arguments{
\item{yin}{A matrix or list holding the sample of measurements for the observed distributions. If \code{yin} is a matrix, each row holds the measurements for one distribution.}

\item{hin}{A list holding the histograms of an observed distribution.}

\item{qin}{A matrix or list holding the quantile functions of the response. If \code{qin} is a matrix, each row holds the quantile function of an observed distribution taking values on \code{optns$qSup}.
Note that only one of the three \code{yin}, \code{hin}, and \code{qin} needs to be input.
If more than one of them are specified, \code{yin} overwrites \code{hin}, and \code{hin} overwrites \code{qin}.}

\item{optns}{A list of options control parameters specified by \code{list(name=value)}.}
}
\value{
A list containing the following components:
\item{dout}{A numeric vector holding the density of the Fréchet mean.}
\item{dSup}{A numeric vector giving the domain grid of \code{dout} when it is a matrix.}
\item{qout}{A numeric vector holding the quantile function of the Fréchet mean.}
\item{qSup}{A numeric vector giving the domain grid of \code{qout}.}
\item{optns}{A list of control options used.}
}
\description{
Obtain Fréchet means of densities with respect to \eqn{L^2}-Wasserstein distance.
}
\details{
Available control options are \code{qSup}, \code{nqSup}, 
\code{bwDen}, \code{ndSup}, \code{dSup}, \code{delta}, 
\code{kernelDen}, \code{infSupport}, and \code{denLowerThreshold}. 
See \code{\link{LocDenReg}} for details.
\describe{
\item{weights}{A vector of weights to compute the weighted barycenter. The length of \code{weights} is equal to the sample size. Default is equal weights.}
}
}
\examples{
xin = seq(0,1,0.05)
yin = lapply(xin, function(x) {
  rnorm(100, rnorm(1,x + x^2,0.005), 0.05)
})
res <- DenFMean(yin=yin)
plot(res)

}
