% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/herd_se.R
\name{hse_infinite}
\alias{hse_infinite}
\title{hse_infinite}
\usage{
hse_infinite(id, n_tested, test_Se, dp)
}
\arguments{
\item{id}{The herdid}

\item{n_tested}{The number tested in each URG}

\item{test_Se}{The sensitivity of the test. This may have length
== 1 if all URG and all herds have the same test_Se. It may
also have length(test_Se) == length(n_tested).}

\item{dp}{The design prevalence (dp) could be length(dp) == 1 if
all URG and herds have the same dp. It could alternatively be
length(dp) == length(n_tested) if diff}
}
\value{
A data.frame. A dataframe is returned with 2 columns: "id" and HSe
}
\description{
Herd Sensitivity calculated with the assumption of an infinite
population
}
\details{
Calculate the Herd sensitivity when multiple samples from
individual units within the herd. The function does not use the
population size to adjust the estimate. This is consistent with
the assumption of an infinite population size and is generally
used when less than 10% of the population has been sampled.
}
\examples{
df <- data.frame(id = seq(1:20),
                 n_tested = rpois(20, 5),
                 test_Se = 0.3,
                 dp = 0.05)

## Calculate the herd level sensitivity for each of these herds given
## the assumption that the herds have an infinite size.
hse_infinite(df$id,
             df$n_tested,
             df$test_Se,
             df$dp)
}
