% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mri_deface.R
\name{mri_deface}
\alias{mri_deface}
\title{MRI Deface}
\usage{
mri_deface(file, brain_template = NULL, face_template = NULL, ...)
}
\arguments{
\item{file}{File to pass to \code{mri_deface}}

\item{brain_template}{\code{gca} brain template file to pass to \code{mri_deface}}

\item{face_template}{\code{gca} face template file to pass to \code{mri_deface}}

\item{...}{Additional arguments to pass to \code{\link{fs_cmd}}}
}
\value{
Result of \code{fs_cmd}, which type depends on
arguments to \code{...}
}
\description{
This calls Freesurfer's \code{mri_deface}
}
\note{
If \code{brain_template} or\code{face_template} is \code{NULL},
they will be downloaded.
}
\examples{
\donttest{
if (have_fs()){
   base_url = "https://surfer.nmr.mgh.harvard.edu/pub/dist/mri_deface"
   url = file.path(base_url, "sample_T1_input.mgz")
   x = tempfile(fileext = ".mgz")
   out = try({
   utils::download.file(url, destfile = x)
   })
   if (!inherits(out, "try-error")) {
      noface = mri_deface(x)
   } else {
      url = paste0(
         "https://raw.githubusercontent.com/muschellij2/kirby21.t1/master/",
         "inst/visit_1/113/113-01-T1.nii.gz")
      x = tempfile(fileext = ".nii.gz")
      out = try({
          utils::download.file(url, destfile = x)
      })
      noface = mri_deface(x)
   }
}
}
}
