% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_surface.R
\name{read.fs.surface.stl.ascii}
\alias{read.fs.surface.stl.ascii}
\title{Read surface mesh in STL ASCII format.}
\usage{
read.fs.surface.stl.ascii(filepath, digits = 6L)
}
\arguments{
\item{filepath}{full path to surface mesh file in STL format.}

\item{digits}{the precision (number of digits after decimal separator) to use when determining whether two x,y,z coords define the same vertex. This is used when the polygon soup is turned into an indexed mesh.}
}
\value{
an `fs.surface` instance. The normals are available in the 'metadata' property.
}
\description{
The STL format is a mesh format that is often used for 3D printing, it stores geometry information. It is known as stereolithography format. A binary and an ASCII version exist. This function reads the ASCII version.
}
\note{
The STL format does not use indices into a vertex list to define faces, instead it repeats vertex coords in each face ('polygon soup'). Therefore, the mesh needs to be reconstructed, which requires the `misc3d` package.
}
\references{
See https://en.wikipedia.org/wiki/STL_(file_format) for a format description.
}
\keyword{internal}
