% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_files.R
\name{find_files}
\alias{find_files}
\title{Find Files on Disk}
\usage{
find_files(
  path = ".",
  pattern = NULL,
  file_names = NA,
  all_files = TRUE,
  recursive = FALSE,
  ignore_case = FALSE,
  find_all = FALSE,
  select = NA
)
}
\arguments{
\item{path}{see \code{\link{list.files}}.}

\item{pattern}{see \code{\link{list.files}}.}

\item{file_names}{character vector of file names (to be checked if the files
exist).}

\item{all_files}{see \code{\link{list.files}}, argument \code{all.files}.}

\item{recursive}{see \code{\link{list.files}}.}

\item{ignore_case}{see \code{\link{list.files}}, argument \code{ignore.case}.}

\item{find_all}{Throw an error if not all files (given by \emph{file_names})
are found?}

\item{select}{A named list of numerical vectors of maximum length 2 named
\code{min} and/or \code{max}.
If given, file searching will be restricted to file attributes corresponding
to the names in the list ranging between \code{min} and \code{max}. See
\emph{examples}.}
}
\value{
A character vector of file names.
}
\description{
Look for files on disk, either scanning a vector of names or searching for
files with \code{\link{list.files}} and throw an error if no files are found.
}
\details{
This is a wrapper to either \code{\link{file.exists}} or
\code{\link{list.files}}, that ensures that (some) files exists. This may
come handy if you want to perform some kind of file manipulation e.g. with
one of the functions listed under \cr
\strong{See Also} \emph{Other file utilities:}.
}
\note{
This is merely a wrapper around \code{\link{file.exists}} or
      \code{\link{list.files}}, depending on whether \emph{file_names} is
      given.
}
\examples{
#\% create some files
files <- unname(sapply(file.path(tempdir(), paste0(sample(letters, 10),
                                              ".", c("R", "Rnw", "txt"))),
                       touch))
print(files)
print(list.files(tempdir(), full.names = TRUE)) # same as above
#\% file names given
find_files(file_names = files[1:3])
##\% some do not exist:
find_files(file_names = c(files[1:3], replicate(2, tempfile())))
try(find_files(file_names = c(files[1:3], replicate(2, tempfile())),
               find_all = TRUE))
##\% all do not exist:
try(find_files(file_names = replicate(2, tempfile())))
#\% path given
find_files(path = tempdir())
##\% change pattern
find_files(path = tempdir(),
           pattern = ".*\\\\.[RrSs]$|.*\\\\.[RrSs]nw$|.*\\\\.txt")
##\% find a specific file by it's basename
find_files(path = tempdir(), pattern = paste0("^", basename(files[1]), "$"))
#\% file_names and path given: file_names beats path
try(find_files(file_names = tempfile(), path = tempdir()))
#\% select by file size:
write.csv(mtcars, file.path(tempdir(), "mtcars.csv"))
find_files(path = tempdir())
find_files(path = tempdir(),
           select = list(size = c(min = 1000))
           )
}
\seealso{
Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{file_modified_last}()},
\code{\link{fromto}()},
\code{\link{grep_file}()},
\code{\link{missing_docs}},
\code{\link{runsed}()},
\code{\link{search_files}()},
\code{\link{search_rows}()},
\code{\link{summary.filesearch}()}

Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_blank_lines}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{file_string}()},
\code{\link{get_lines_between_tags}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{grep_file}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{runsed}()},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
\concept{searching functions}
