% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graphs.R
\name{HeatMap}
\alias{HeatMap}
\title{HeatMap}
\usage{
HeatMap(
  Min,
  Max,
  chr = NULL,
  Info,
  FreqNbG,
  Dir = NULL,
  Weights = NULL,
  Weight.thres = 0.05,
  NbAdjM = 0,
  Subsets = NULL
)
}
\arguments{
\item{Min}{the starting position value of the region}

\item{Max}{the end position value of the region}

\item{chr}{a string providing the chromosome name, optional}

\item{Info}{a data.frame providing information about markers}

\item{FreqNbG}{a list of data.frames (one per population) with two columns: Freq and NbGamete}

\item{Dir}{a string providing the name of the directory where the graph should be saved, optional}

\item{Weights}{a vector of weights associated with each marker, optional}

\item{Weight.thres}{a numeric value. Markers with weights lower than this threshold
will be discarded from the graphical representation. Optional.}

\item{NbAdjM}{an integer providing the number of markers before and after the highlighted regions 
that should be added to the graphical representation, optional.}

\item{Subsets}{a list of character vectors with the population names, optional.}
}
\value{
A heatmap where rows correspond to markers, and columns to populations.
}
\description{
Make a frequency heatmap
}
\examples{
## The full example execution takes a few seconds.
# data(Freq);data(NbGamete)
# FreqNbG <- BuildFreqNbG(Freq,NbGamete)
# HFst.m <- HudsonFst.m(FreqNbG)

## Two sets of populations to contrast
# Contrast <- list(America=c("Colombian","Maya"),Europe=c("Tuscan","Italian"))
# Profiles <- HudsonFst.prof(HFst.m,Contrast=Contrast)
# PS <- ProfilingSummary(Profiles,Info) 

# RefLevel <- rapply(Profiles,median,classes = "numeric",how='list')
# Ratio.thres <- 3
# NbSnp.min <- 1
# CS <- ContrastSummary(PS, RefLevel,
#                       Ratio.thres=Ratio.thres,
#                       NbSnp.min=NbSnp.min)
# NbSel.thres <- 2
# TopRegions <- ContrastTopRegions(CS = CS,Crit = 'NbSel',Info = Info,
#                                  Thres = NbSel.thres, Simplify=TRUE)
# HeatMap(Min = TopRegions[1,]$Start,
#         Max = TopRegions[1,]$End,
#         chr = TopRegions[1,]$Chromosome,
#         Info = Info,
#         FreqNbG = FreqNbG,
#         Subsets = Contrast)                                
}
