% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FstBattia.R
\name{ProfilingSummary}
\alias{ProfilingSummary}
\title{ProfilingSummary}
\usage{
ProfilingSummary(FstProfiles, SnpInfo)
}
\arguments{
\item{FstProfiles}{a list of Fst profiles as obtained from function \code{HudsonFst.prof}}

\item{SnpInfo}{a data.frame providing information about markers}
}
\value{
a list of data.frame. Each data.frame summarizes a Fst profile, in terms of number of segments, 
Start and End positions, length (i.e. number of markers)  and Fst level of each segment.
}
\description{
Summary of Fst profiles
}
\examples{
data(Freq);data(NbGamete);data(Info)
FreqNbG <- BuildFreqNbG(Freq,NbGamete)
HFst.m <- HudsonFst.m(FreqNbG)
TwoPops <- list(First="Colombian",Second="Tuscan")
HFst.prof <- HudsonFst.prof(HFst.m,Contrast=TwoPops)
PS <- ProfilingSummary(HFst.prof,Info)
}
