% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASDC_DNA.R
\name{ASDC_DNA}
\alias{ASDC_DNA}
\title{Adaptive skip dinucleotide composition_DNA) (ASDC_DNA)}
\usage{
ASDC_DNA(seqs, ORF = FALSE, reverseORF = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{ORF}{(Open Reading Frame) is a logical parameter. If it is set to true, ORF region of each sequence is considered instead of the original sequence (i.e., 3-frame).}

\item{reverseORF}{is a logical parameter. It is enabled only if ORF is true.
If reverseORF is true, ORF region will be searched in the sequence and also in the reverse complement of the sequence (i.e., 6-frame).}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
The function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is 16 (All posible nucleotide pairs).
}
\description{
This descriptor sufficiently considers the correlation information present not only between adjacent nucleotides but also between intervening nucleotides
This function calculates frequency of pair nucleotides omitting gaps between them. Then this function normalizes each value through dividing each frequency by summition(frequencies).
}
\examples{


fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
fileLNC<-fa.read(file=fileLNC,alphabet="dna")[1:5]
mat1<-ASDC_DNA(seqs=fileLNC,ORF=TRUE,reverseORF=FALSE)

}
\references{
Wei L, Zhou C, Chen H, Song J, Su R. ACPred-FL: a sequence-based predictor using effective feature representation to improve the prediction of anti-cancer peptides. Bioinformatics (2018).
}
