% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PseKRAAC_T3A.R
\name{PseKRAAC_T3A}
\alias{PseKRAAC_T3A}
\title{Pseudo K_tuple Reduced Amino Acid Composition Type-3A (PseKRAAC_T3A)}
\usage{
PseKRAAC_T3A(
  seqs,
  type = "gap",
  Grp = 2,
  GapOrLambdaValue = 2,
  k = 4,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{type}{This parameter has two valid value "lambda" and "gap". "lambda"
calls lambda_model function and "gap" calls gap_model function.}

\item{Grp}{is a numeric value. It shows the id of an amino acid group.
Please find the available groups in the detail section.}

\item{GapOrLambdaValue}{is an integer.
If type is gap, this value shows number of gaps between two k-mers.
If type is lambda, the value of GapOrLambdaValue shows the number of gaps between each two amino acids of k-mers.}

\item{k}{This parameter keeps the value of k in k-mer.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is (Grp)^k.
}
\description{
There are 16 types of PseKRAAC function.
In the functions, a (user-selected) grouping of the amino acids might be used to reduce the amino acid alphabet.
Also, the functions have a type parameter.
The parameter determines the protein sequence analyses which can be either gap or lambda-correlation.
PseKRAAC_type3 contain two type: type3A and type3B. 'PseKRAAC_T3A' contains Grp 2-20.
}
\details{
Groups:
Grp2=c('AGSPDEQNHTKRMILFYVC', 'W'),
Grp3=c('AGSPDEQNHTKRMILFYV', 'W', 'C'),
Grp4=c('AGSPDEQNHTKRMIV', 'W', 'YFL', 'C'),
Grp5=c('AGSPDEQNHTKR', 'W', 'YF', 'MIVL', 'C'),
Grp6=c('AGSP', 'DEQNHTKR', 'W', 'YF', 'MIL', 'VC'),
Grp7=c('AGP', 'DEQNH', 'TKRMIV', 'W', 'YF', 'L', 'CS'),
Grp8=c('AG', 'DEQN', 'TKRMIV', 'HY', 'W', 'L', 'FP', 'CS'),
Grp9=c('AG', 'P', 'DEQN', 'TKRMI', 'HY', 'W', 'F', 'L', 'VCS'),
Grp10=c('AG', 'P', 'DEQN', 'TKRM', 'HY', 'W', 'F', 'I', 'L', 'VCS'),
Grp11=c('AG', 'P', 'DEQN', 'TK', 'RI', 'H', 'Y', 'W', 'F', 'ML', 'VCS'),
Grp12=c('FAS', 'P', 'G', 'DEQ', 'NL', 'TK', 'R', 'H', 'W', 'Y', 'IM', 'VC'),
Grp13=c('FAS', 'P', 'G', 'DEQ', 'NL', 'T', 'K', 'R', 'H', 'W', 'Y', 'IM', 'VC'),
Grp14=c('FA', 'P', 'G', 'T', 'DE', 'QM', 'NL', 'K', 'R', 'H', 'W', 'Y', 'IV', 'CS'),
Grp15=c('FAS', 'P', 'G', 'T', 'DE', 'Q', 'NL', 'K', 'R', 'H', 'W', 'Y', 'M', 'I', 'VC'),
Grp16=c('FA', 'P', 'G', 'ST', 'DE', 'Q', 'N', 'K', 'R', 'H', 'W', 'Y', 'M', 'L', 'I', 'VC'),
Grp17=c('FA', 'P', 'G', 'S', 'T', 'DE', 'Q', 'N', 'K', 'R', 'H', 'W', 'Y', 'M', 'L', 'I', 'VC'),
Grp18=c('FA', 'P', 'G', 'S', 'T', 'DE', 'Q', 'N', 'K', 'R', 'H', 'W', 'Y', 'M', 'L', 'I', 'V', 'C'),
Grp19=c('FA', 'P', 'G', 'S', 'T', 'D', 'E', 'Q', 'N', 'K', 'R', 'H', 'W', 'Y', 'M', 'L', 'I', 'V', 'C'),
Grp20=c('F', 'A', 'P', 'G', 'S', 'T', 'D', 'E', 'Q', 'N', 'K', 'R', 'H', 'W', 'Y', 'M', 'L', 'I', 'V', 'C')
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")

mat1<-PseKRAAC_T3A(seqs=filePrs,type="gap",Grp=4,GapOrLambdaValue=3,k=2)

mat2<-PseKRAAC_T3A(seqs=filePrs,type="lambda",Grp=4,GapOrLambdaValue=3,k=2)
}
\references{
Zuo, Yongchun, et al. "PseKRAAC: a flexible web server for generating pseudo K-tuple reduced amino acids composition." Bioinformatics 33.1 (2017): 122-124.
}
