% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_5bit_T1.R
\name{binary_5bit_T1}
\alias{binary_5bit_T1}
\title{Binary - 5bit - Type1 (binary_5bit_T1)}
\usage{
binary_5bit_T1(
  seqs,
  binaryType = "numBin",
  label = c(),
  outFormat = "mat",
  outputFileDist = ""
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{binaryType}{It can take any of the following values: ('strBin','logicBin','numBin').
'strBin'(String binary): each amino acid is represented by a string containing 20 characters(0-1). For example, A = ALANIN = "1000000...0"
'logicBin'(logical value): Each amino acid is represented by a vector containing 20 logical entries. For example, A = ALANIN = c(T,F,F,F,F,F,F,...F)
'numBin' (numeric bin): Each amino acid is represented by a numeric (i.e., integer) vector containing 20 numerals. For example, A = ALANIN = c(1,0,0,0,0,0,0,...,0)}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output is different depending on the outFormat parameter ('mat' or 'txt').
If outFormat is set to 'mat', it returns a feature matrix for sequences with the same lengths.
The number of rows is equal to the number of sequences and if binaryType is 'strBin', the number of columns is the length of the sequences.
Otherwise, it is equal to (length of the sequences)*5.
If outFormat is 'txt', all binary values will be written to a the output is written to a tab-delimited file. Each line in the file shows the binary format of a sequence.
}
\description{
This function categorizes amino acids in 5 groups.
Then represent group of amino acids by a 5 dimentional vector i.e.{e1, e2, e3, e4, e5}.
e1={G, A, V, L, M, I}, e2={F, Y, W}, e3={K, R, H}, e4={D, E}, e5={S, T, C, P, N, Q}. e1 is ecoded by 10000
e2 is encoded by 01000 and ... and e5 is encoded by 00001.
}
\details{
The type of the binary format is determined by the binaryType parameter.
For details about each format, please refer to the description of the binaryType parameter.
}
\note{
This function is provided for sequences with the same lengths.
Users can use 'txt' option in outFormat for sequences with different lengths.
Warning: If outFormat is set to 'mat' for sequences with different lengths, it returns an error.
Also, when output format is 'txt', label information is not shown in the text file.
It is noteworthy that 'txt' format is not usable for machine learning purposes if sequences have different sizes. Otherwise 'txt' format
is also usable for machine learning purposes.
}
\examples{

ptmSeqsADR<-system.file("extdata/",package="ftrCOOL")
ptmSeqsVect<-as.vector(read.csv(paste0(ptmSeqsADR,"/ptmVect101AA.csv"))[,2])
mat<-binary_5bit_T1(seqs = ptmSeqsVect, binaryType="numBin",outFormat="mat")

}
