% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjointTriad.R
\name{conjointTriad}
\alias{conjointTriad}
\title{Conjoint Triad (conjointTriad)}
\usage{
conjointTriad(seqs, normalized = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows equals to the number of sequences and
the number of columns is 7^3.
}
\description{
This function calculates the grouped tripeptide composition with the conjoint triad grouping type.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat1<-conjointTriad(seqs=filePrs)

}
