% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{discretize_get_bins}
\alias{discretize_get_bins}
\title{Get the data frame thresholds for discretization}
\usage{
discretize_get_bins(data, n_bins = 5, input = NULL)
}
\arguments{
\item{data}{Data frame source}

\item{n_bins}{The number of desired bins (or segments) that each variable will have.}

\item{input}{Vector of string containing all the variables that will be processed.
If empty it will run for all numerical variables that match the following condition, the number of unique values
must be higher than the ones defined at 'n_bins' parameter. NAs values are automatically handled by converting
them into another category (more info about it at
\url{https://livebook.datascienceheroes.com/data-preparation.html#treating-missing-values-in-numerical-variables}).
This function must be used with \link{discretize_df}.
If it is needed a different number of bins per variable, then the function must be called more than once.}
}
\value{
Data frame containing the thresholds or cuts to bin every variable
}
\description{
It takes a data frame and returns another data frame indicating the threshold for each bin (or segment)
in order to discretize the variable.
}
