% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{comp_stat}
\alias{comp_stat}
\title{Compute multiple statistics}
\usage{
comp_stat(MatX, MatY, stat = c("mo", "med"))
}
\arguments{
\item{MatX}{numeric matrix of dimension \verb{n_point x n} containing \code{n}
trajectories (in columns) of size \code{n_point} (in rows).}

\item{MatY}{numeric matrix of dimension \verb{n_point x m} containing \code{m}
trajectories (in columns) of size \code{n_point} (in rows).}

\item{stat}{character string or vector of character string, name of the
statistics for which the p-values will be computed, among \code{"mo"}, \code{"med"},
\code{"wmw"}, \code{"hkr"}, \code{"cff"}.}
}
\value{
list of named numeric value corresponding to the statistic values
listed in \code{stat} input.
}
\description{
Computation of the different statistics defined in the package.
See Smida et al (2022) for more details.
}
\details{
For HKR statistics, only the values of the two statistics, namely \code{HKR1} and
\code{HKR2} and not the eigen values (see \code{\link[=stat_hkr]{stat_hkr()}} for
more details).
}
\examples{
simu_data <- simul_data(
    n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 10, 
    delta_shape = "constant", distrib = "normal"
)

MatX <- simu_data$mat_sample1
MatY <- simu_data$mat_sample2

res <- comp_stat(MatX, MatY, stat = c("mo", "med", "wmw", "hkr", "cff"))
res
}
\references{
Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022)
A median test for functional data, Journal of Nonparametric Statistics,
34:2, 520-553,
\doi{10.1080/10485252.2022.2064997},
\href{https://hal.science/hal-03658578}{hal-03658578}
}
\seealso{
\code{\link[=stat_mo]{stat_mo()}}, \code{\link[=stat_med]{stat_med()}},
\code{\link[=stat_wmw]{stat_wmw()}}, \code{\link[=stat_hkr]{stat_hkr()}},
\code{\link[=stat_cff]{stat_cff()}}
}
\author{
Zaineb Smida, Ghislain DURIF, Lionel Cucala
}
