% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{par.mFPCA}
\alias{par.mFPCA}
\title{Setting mixed functional principal component analysis (mFPCA) defaults}
\usage{
par.mFPCA(perc_pca = 0.9, perc_basis_x_pca = 1, perc_basis_h = 0.2)
}
\arguments{
\item{perc_pca}{Percentage of the total variability used to select the number \eqn{L} of principal components.}

\item{perc_basis_x_pca}{Multiplied by the maximum number of basis of the registered functions for each time point in \eqn{\mathcal{D}_{Y}}, it is the number of basis functions of the registered functions in the mFPCA.}

\item{perc_basis_h}{Multiplied by the mean number of basis of the warping functions for each time point in \eqn{\mathcal{D}_{Y}}, it is the number of basis functions of the warping functions in the mFPCA.}
}
\description{
This is an internal function of package \code{FRTM} which allows controlling the parameters used in the mFPCA in the FRTM method.
}
\examples{
library(funcharts)
par.mFPCA()
}
\seealso{
\code{\link{FRTM_PhaseI}}
}
