% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{par.rtr}
\alias{par.rtr}
\title{Setting real-time registration step defaults}
\usage{
par.rtr(
  seq_x = NULL,
  delta_d = 0.05,
  delta_v = 0.03,
  delta_c = 0.04,
  Delta = 0.1,
  length_grid_window = 10,
  length_grid_owindow = 20,
  eval_seq_der = seq(0.02, 0.1, length.out = 10),
  perc_basis_x_reg = 0.3
)
}
\arguments{
\item{seq_x}{Discretized sequence in the monitoring domain \eqn{\mathcal{D}_{m}}.}

\item{delta_d}{The parameter \eqn{\delta_{d}} in the adaptive band constraint calculation.}

\item{delta_v}{The parameter \eqn{\delta_{v}} in the adaptive band constraint calculation.}

\item{delta_c}{The parameter \eqn{\delta_{c}} in the adaptive band constraint calculation.}

\item{Delta}{The parameter \eqn{\Delta} in the adaptive band constraint calculation.}

\item{length_grid_window}{Number of points to be explored in the interval of the band constraint for each point in \eqn{\mathcal{D}_{m}} when the adaptive band constraint is considered.}

\item{length_grid_owindow}{Number of points to be explored in the interval of the band constraint for each point in \eqn{\mathcal{D}_{m}} when the original band constraint is considered.}

\item{eval_seq_der}{If multiplied by the template domain range, the distances from the domain right boundaries  over which are calculated the first derivative
to mitigate the effects of possible estimation errors in the adaptive band constraint calculation.}

\item{perc_basis_x_reg}{Multiplied by the number of observed discrete points, it is the number of basis functions used in the real-time registration step for each time point.
This latter number cannot be grater than \code{n_basis_xall}.}
}
\description{
This is an internal function of package \code{FRTM} which allows controlling the parameters to implement real-time registration step in the FRTM method.
}
\examples{
library(funcharts)
par.rtr()

}
\seealso{
\code{\link{FRTM_PhaseI}}
}
\author{
F. Centofanti
}
