% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_feve.R
\name{fd_feve}
\alias{fd_feve}
\title{Compute Functional Evenness (FEve)}
\usage{
fd_feve(traits = NULL, sp_com, dist_matrix = NULL)
}
\arguments{
\item{traits}{Trait matrix with species as rows and traits as columns.
It has to contain exclusively numerical values. This can be
either a \code{matrix}, a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}}
object.}

\item{sp_com}{Site-species matrix with sites as rows and species as columns
if not provided, the function considers all species with equal
abundance in a single site. This can be either a \code{matrix},
a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.}

\item{dist_matrix}{A dissimilarity matrix that can be provided instead of a
trait data.frame (default: \code{NULL}).
This can be either a \code{matrix}, a \code{data.frame},
or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.}
}
\value{
a data.frame with two columns:
\itemize{
\item \code{site} character column that contains site names based on input \code{sp_com}
row names,
\item \code{FEve} numeric column that contains FEve values corresponding to each site.
}

NB: By definition FEve is equal to \code{NA} when the number of species per site
is strictly lower than 3.
}
\description{
This function computes Functional Evenness (FEve) following Villéger et al.
(2008). NB: By definition FEve is equal to \code{NA} when the number of species
per site is strictly lower than 3.
}
\section{Parallelization}{

The computation of this function can be parallelized thanks to
\code{\link[future:plan]{future::plan()}}. To get more information on how to parallelize your
computation please refer to the parallelization vignette with:
\code{vignette("fundiversity_1-parallel", package = "fundiversity")}
}

\examples{
data(traits_birds)
fd_feve(traits_birds)

}
\references{
Villéger, S., Mason, N.W.H., Mouillot, D., 2008. New Multidimensional
Functional Diversity Indices for a Multifaceted Framework in Functional
Ecology. Ecology 89, 2290–2301. \doi{10.1890/07-1206.1}
}
