% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funique.R
\name{funique}
\alias{funique}
\title{A faster unique function}
\usage{
funique(x)
}
\arguments{
\item{x}{Input data. If x is not a data frame or date-time object, then it is
simply passed to \code{\link[base]{unique}}}
}
\value{
The unique rows/values of x.
}
\description{
Similar to \code{\link[base]{unique}}, only optimized for working with
date-time columns.
}
\examples{

## create example data set
d <- data.frame(
  x = rnorm(1000),
  y = seq.POSIXt(as.POSIXct("2018-01-01"),
    as.POSIXct("2018-12-31"), length.out = 10)
)

## sample to create version with duplicates
dd <- d[c(1:1000, sample(1:1000, 500, replace = TRUE)), ]

## get only unique rows
head(funique(dd))

## check output
identical(unique(dd), funique(dd))

}
