% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funplot.R
\name{funplot}
\alias{funplot}
\title{Create a funnel plot}
\usage{
funplot(input, fundata, byvar)
}
\arguments{
\item{input}{A data frame of the raw data with a denominator (total) as d, and numerator (events) as n}

\item{fundata}{A data frame from the fundata function which holds the control limits to be overlayed.}

\item{byvar}{A subgroup variable to color the plots by (Optional). Variable name must be wrapped in quotes.}
}
\description{
This function will return a ggplot2 object. It requires two data frames: the sample data frame and the control limit data frame. An optional sub-group variable can be present in the sample data frame for coloring the funnel plot.
}
\examples{
#My sample data
my_data  <- data.frame(id=c('A','B','C','D','E'), n=c(2,5,10,15,18), d=c(20,20,20,20,20))

#Process sample data through fundata
my_fpdata <- fundata(my_data, alpha=0.95, alpha2=0.998, method='approximate', step=0.5)

#Use sample data and fundata to make the plot.
my_plot <- funplot(my_data, my_fpdata)

#View plot
my_plot
}
