% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funscore.R
\name{funscore}
\alias{funscore}
\title{Score Proportion Data}
\usage{
funscore(input, benchmark, alpha = 0.95, alpha2 = 0.998,
  method = "approximate")
}
\arguments{
\item{input}{A data frame of your sample data, in the format outlined above.}

\item{benchmark}{A number between 0 and 1 representing the benchmark (e.g. null) estimate for which confidence limits are calculated for. If not specified, the overall proportion of events is used.}

\item{alpha}{A number between 0 and 1 representing the desired confidence limit (e.g. 0.95)}

\item{alpha2}{A number between 0 and 1 representing the desired confidence limit (e.g. 0.998)}

\item{method}{Choose between approximate or exact binomial control limits.}
}
\description{
This function will return a single data frame consisting of (1) the original sample data and (2) two categorical variables which record whether each sample data point is In Control or Extreme, relative to the two sets of alphas specified. These two categorical variables might be useful for additional analyses or coloring the funnel plot.
}
\examples{
#My sample data
my_data  <- data.frame(id=c('A','B','C','D','E'), n=c(2,5,10,15,18), d=c(20,20,20,20,20))

#Score sample data
my_scoredata <- funscore(my_data, alpha=0.95, alpha2=0.998, method='approximate')

#View scored data
head(my_scoredata)
}
