% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestData.R
\name{TestData}
\alias{TestData}
\title{TestData Class}
\description{
This class implements \link{TestData} object to be predicted.
A \link{TestData} object can only exist as a component of a \link{TestLayer} or a \link{TestMetaLayer} object.
}
\seealso{
\link{TrainData}
}
\section{Super class}{
\code{\link[fuseMLR:Data]{fuseMLR::Data}} -> \code{TestData}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TestData-new}{\code{TestData$new()}}
\item \href{#method-TestData-print}{\code{TestData$print()}}
\item \href{#method-TestData-getData}{\code{TestData$getData()}}
\item \href{#method-TestData-getTestLayer}{\code{TestData$getTestLayer()}}
\item \href{#method-TestData-clone}{\code{TestData$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getCompleteData"><a href='../../fuseMLR/html/Data.html#method-Data-getCompleteData'><code>fuseMLR::Data$getCompleteData()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getDataFrame"><a href='../../fuseMLR/html/Data.html#method-Data-getDataFrame'><code>fuseMLR::Data$getDataFrame()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getId"><a href='../../fuseMLR/html/Data.html#method-Data-getId'><code>fuseMLR::Data$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndCol"><a href='../../fuseMLR/html/Data.html#method-Data-getIndCol'><code>fuseMLR::Data$getIndCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getIndSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getIndSubset'><code>fuseMLR::Data$getIndSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getSetDiff"><a href='../../fuseMLR/html/Data.html#method-Data-getSetDiff'><code>fuseMLR::Data$getSetDiff()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="getVarSubset"><a href='../../fuseMLR/html/Data.html#method-Data-getVarSubset'><code>fuseMLR::Data$getVarSubset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="impute"><a href='../../fuseMLR/html/Data.html#method-Data-impute'><code>fuseMLR::Data$impute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="Data" data-id="setDataFrame"><a href='../../fuseMLR/html/Data.html#method-Data-setDataFrame'><code>fuseMLR::Data$setDataFrame()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestData-new"></a>}}
\if{latex}{\out{\hypertarget{method-TestData-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new object from the current class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestData$new(id, data_frame, new_layer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
Object ID.}

\item{\code{data_frame}}{\code{data.frame}\cr
\code{data.frame} containing data.}

\item{\code{new_layer}}{\code{TestLayer} \cr
Layer where to store the current object.}

\item{\code{ind_col}}{\code{character}\cr
Column name containing individual IDs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestData-print"></a>}}
\if{latex}{\out{\hypertarget{method-TestData-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestData$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestData-getData"></a>}}
\if{latex}{\out{\hypertarget{method-TestData-getData}{}}}
\subsection{Method \code{getData()}}{
Getter of the current \code{data.frame} wihtout individual
ID variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestData$getData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{data.frame} without individual ID nor target variables is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestData-getTestLayer"></a>}}
\if{latex}{\out{\hypertarget{method-TestData-getTestLayer}{}}}
\subsection{Method \code{getTestLayer()}}{
Getter of the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestData$getTestLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The layer (from class \link{TestLayer}) on which the current train data are stored
is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TestData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
