% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmt.R
\name{bmt}
\alias{bmt}
\title{Big Merge Tracker}
\usage{
bmt(x, alpha = 0.1, small.perturbation = 10^(-6))
}
\arguments{
\item{x}{observation vector}

\item{alpha}{merging threshold. Default is 0.1}

\item{small.perturbation}{a small positive number to remove ties. Default is 10^(-6)}
}
\value{
\enumerate{
\item path - number of clusters on the big merge path
\item lambda.path - sequence of lambda where clusters merge
\item index - cluster index at the point where clusters merge
\item merge - merge points
\item split - split points
\item prob - merging proportion
\item boundaries - cluster boundaries
}
}
\description{
Solves an L1 relaxed univariate clustering criterion and returns a
    sequence of \eqn{\lambda} values where the clusters merge
}
\details{
solves a convex relaxation of the univariate clustering criterion given by equation
    (2) in the referenced paper and generates a sequence of cluster merges and corresponding
     \eqn{\lambda} values. See algorithm 1 in the referenced paper for more details.
}
\examples{
library(fusionclust)
set.seed(42)
x<- c(rnorm(1000,-2,1), rnorm(1000,2,1))
out<- bmt(x)

}
\references{
\enumerate{
\item P. Radchenko, G. Mukherjee, Convex clustering via l1 fusion penalization,
 J. Roy. Statist, Soc. Ser. B (Statistical Methodology) (2017)
 doi:10.1111/rssb.12226.
}
}
\seealso{
\code{\link{nclust}}
}
