% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{rand.t.test.w}
\alias{rand.t.test.w}
\title{Random t-test}
\usage{
rand.t.test.w(cvoutput, n.perm = 999)
}
\arguments{
\item{cvoutput}{Cross-validation output either from \code{\link{cv.w}} or
\code{\link{cv.pr.w}}.}

\item{n.perm}{The number of permutation times to get the p value, which
assesses whether using the current number of components is significantly
different from using one less.}
}
\value{
A matrix of the statistics of the cross-validation results. Each
component is described below:
\describe{
\item{\code{R2}}{the coefficient of determination (the larger, the
better the fit).}
\item{\code{Avg.Bias}}{average bias.}
\item{\code{Max.Bias}}{maximum bias.}
\item{\code{Min.Bias}}{minimum bias.}
\item{\code{RMSEP}}{root-mean-square error of prediction (the smaller,
the better the fit).}
\item{\code{delta.RMSEP}}{the percent change of RMSEP using the current
number of components than using one component less.}
\item{\code{p}}{assesses whether using the current number of components
is significantly different from using one component less, which is used
to choose the last significant number of components to avoid
over-fitting.}
\item{\code{-}}{The degree of overall compression is assessed by doing
linear regression to the cross-validation result and the observed
climate values.
\itemize{
\item \code{Compre.b0}: the intercept.
\item \code{Compre.b1}: the slope (the closer to 1, the less the
overall compression).
\item \code{Compre.b0.se}: the standard error of the intercept.
\item \code{Compre.b1.se}: the standard error of the slope.
}
}
}
}
\description{
Do a random t-test to the cross-validation results.
}
\examples{
\dontrun{

## Random t-test
rand_pr_tf_Tmin2 <- fxTWAPLS::rand.t.test.w(cv_pr_tf_Tmin2, n.perm = 999)

# note: choose the last significant number of components based on the p-value,
# see details at Liu Mengmeng, Prentice Iain Colin, ter Braak Cajo J. F.,
# Harrison Sandy P.. 2020 An improved statistical approach for reconstructing
# past climates from biotic assemblages. Proc. R. Soc. A. 476: 20200346.
# <https://doi.org/10.1098/rspa.2020.0346>
}

}
\seealso{
\code{\link{cv.w}} and \code{\link{cv.pr.w}}
}
