% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCV.R
\name{GCV}
\alias{GCV}
\title{GCV (generalized cross-validation)}
\usage{
GCV(X, Y, k, W = diag(ncol(X)))
}
\arguments{
\item{X}{matrix of explanatory variables (design matrix)}

\item{Y}{vector of response variables}

\item{k}{shrinkage parameter (>0); it is the "lambda" parameter}

\item{W}{matrix of weights (default is the identity matrix)}
}
\value{
The value of GCV
}
\description{
The CGV function gives the sum of cross-validated squared errors
that can be used to optimize tuning parameters in ridge regression and
 generalized ridge regression.
  See Golub et al. (1979), and Sections 2.3 and 3.3 of Yang and Emura (2017) for details.
}
\examples{
n=100 # no. of observations
p=100 # no. of dimensions
q=r=10 # no. of nonzero coefficients
beta=c(rep(0.5,q),rep(0.5,r),rep(0,p-q-r))
X=X.mat(n,p,q,r)
Y=X\%*\%beta+rnorm(n,0,1)
GCV(X,Y,k=1)
}
\references{
Yang SP, Emura T (2017) A Bayesian approach with generalized ridge estimation
 for high-dimensional regression and testing, Commun Stat-Simul 46(8): 6083-105.

Golub GH, Heath M, Wahba G (1979) Generalized cross-validation as
 a method for choosing a good ridge parameter. Technometrics 21:215–223.
}
