% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{fullscreen}
\alias{fullscreen}
\title{Configure Fullscreen Plugin}
\usage{
fullscreen(
  key = "fullscreen",
  autoFit = TRUE,
  trigger = NULL,
  onEnter = NULL,
  onExit = NULL,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{autoFit}{Whether to auto-fit the canvas size to the screen when in
fullscreen mode (boolean, default: TRUE).}

\item{trigger}{Methods to trigger fullscreen, e.g.,
list(request = "button", exit = "escape") (list, default: NULL).}

\item{onEnter}{Callback function after entering fullscreen mode (JS function, default: NULL).}

\item{onExit}{Callback function after exiting fullscreen mode (JS function, default: NULL).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/fullscreen}.}
}
\value{
A list with the configuration settings for the fullscreen plugin.
}
\description{
Creates a configuration object for the fullscreen plugin in G6.
This plugin enables fullscreen mode for the graph.
}
\examples{
# Basic configuration
config <- fullscreen()

# Custom configuration
config <- fullscreen(
  key = "my-fullscreen",
  autoFit = TRUE,
  trigger = list(
    request = "F",
    exit = "Esc"
  ),
  onEnter = JS("() => {
    console.log('Entered fullscreen mode');
  }"),
  onExit = JS("() => {
    console.log('Exited fullscreen mode');
  }")
)
}
