% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_array_tabX.R
\name{api-tabDist}
\alias{api-tabDist}
\alias{tabDist}
\title{Marginalize and condition in multidimensional array.}
\usage{
tabDist(tab, marg = NULL, cond = NULL, normalize = TRUE)
}
\arguments{
\item{tab}{Multidimensional array with dimnames.}

\item{marg}{A specification of the desired margin; a character vector, a
numeric vector or a right hand sided formula.}

\item{cond}{A specification of what is conditioned on. Can take two forms:
Form one is a a character vector, a numeric vector or a right hand sided
formula. Form two is as a simple slice of the array, which is a list of
the form var1=value1, var2=value2 etc.}

\item{normalize}{Should the result be normalized to sum to 1.}
}
\value{
A multidimensional array.
}
\description{
Marginalize and condition in a multidimensional array
which is assumed to represent a discrete multivariate
distribution.
}
\examples{

hec <- HairEyeColor

is.named.array( hec )
## We need dimnames, and names on the dimnames

## Marginalize:
tabDist(hec, marg= ~Hair + Eye)
tabDist(hec, marg= ~Hair:Eye)
tabDist(hec, marg= c("Hair", "Eye"))
tabDist(hec, marg= 1:2)

tabDist(hec, marg= ~Hair + Eye, normalize=FALSE)

## Condition
tabDist(hec, cond= ~Sex + Hair)
tabDist(hec, cond= ~Sex:Hair)
tabDist(hec, cond= c("Sex", "Hair"))
tabDist(hec, cond= c(3,1))

tabDist(hec, cond= list(Hair="Black"))
tabDist(hec, cond= list(Hair=1))

\dontrun{
## This will fail
tabDist(hec, cond= list(Hair=c("Black", "Brown")))
tabDist(hec, cond= list(Hair=1:2))
}
## But this will do the trick
a <- tabSlice(hec, slice=list(Hair=c("Black", "Brown")))
tabDist(a, cond=~Hair)

## Combined
tabDist(hec, marg=~Hair+Eye, cond=~Sex)
tabDist(hec, marg=~Hair+Eye, cond="Sex")

tabDist(hec, marg=~Hair+Eye, cond=list(Sex="Male"))
tabDist(hec, marg=~Hair+Eye, cond=list(Sex="Male"), normalize=FALSE)

tabDist(hec, cond=list(Sex="Male"))
tabDist(hec, cond=list(Sex="Male"), normalize=FALSE)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
