% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period1.R
\name{analyze.p1}
\alias{analyze.p1}
\title{Apply Period 1 Analysis}
\usage{
analyze.p1(train, test, ratedPW)
}
\arguments{
\item{train}{A list containing \emph{k} datasets that will be used to train
the machine learning model.}

\item{test}{A list containing \emph{k} datasets that will be used to test the
machine learning model and calculate CV error measures.}

\item{ratedPW}{A kW value that describes the (common) rated power of the
selected turbines (REF and CTR-b).}
}
\value{
The function returns a list containing period 1 analysis results as
  follows. \describe{ \item{\code{opt.cov}}{A character vector presenting the
  names of predictor variables chosen for the optimal set.}
  \item{\code{pred.REF}}{A list of \eqn{k} datasets each representing the
  \eqn{k}th fold's period 1 prediction for the REF turbine.}
  \item{\code{pred.CTR}}{A list of \eqn{k} datasets each representing the
  \eqn{k}th fold's period 1 prediction for the CTR-b turbine.}
  \item{\code{err.REF}}{A data frame containing \eqn{k}-fold CV based RMSE
  values and BIAS values for the REF turbine model (so \eqn{k} of them for
  both). The first column includes the RMSE values and the second column
  includes the BIAS values.} \item{\code{err.CTR}}{A data frame containing
  \eqn{k}-fold CV based RMSE values and BIAS values for the CTR-b turbine
  model. Similarly structured with \code{err.REF}.}
  \item{\code{biasCurve.REF}}{A \eqn{k} by \eqn{m} matrix describing the
  binned BIAS (technically speacking, `residuals' which are the negative
  BIAS) curve for the REF turbine model, where \eqn{m} is the number of power
  bins.} \item{\code{biasCurve.CTR}}{A \eqn{k} by \eqn{m} matrix describing
  the binned BIAS curve for the CTR-b turbine model.}}
}
\description{
Conducts period 1 analysis; selects the optimal set of variables that
minimizes a \emph{k}-fold CV error measure and establishes a machine learning
model that predicts power output of REF and CTR-b turbines by using period 1
data.
}
\note{
\bold{VERY IMPORTANT!} \itemize{ \item Selecting the optimal set of
  variables will take a significant amount of time. For example, with a
  typical size of an annual dataset, the evaluation of one set of variables
  for a single fold testing may take about 20-40 minutes (from the authors'
  experience). \item To help understand the progress of the selection, some
  informative messages will be displayed while this function runs.}
}
\examples{
df.ref <- with(wtg, data.frame(time = time, turb.id = 1, wind.dir = D,
 power = y, air.dens = rho))
df.ctrb <- with(wtg, data.frame(time = time, turb.id = 2, wind.spd = V,
 power = y))
df.ctrn <- df.ctrb
df.ctrn$turb.id <- 3

data <- arrange.data(df.ref, df.ctrb, df.ctrn, p1.beg = '2014-10-24',
 p1.end = '2014-10-25', p2.beg = '2014-10-25', p2.end = '2014-10-26',
 k.fold = 2)

p1.res <- analyze.p1(data$train, data$test, ratedPW = 1000)
p1.res$opt.cov #This provides the optimal set of variables.

}
\references{
H. Hwangbo, Y. Ding, and D. Cabezon, 'Machine Learning Based
  Analysis and Quantification of Potential Power Gain from Passive Device
  Installation,' arXiv:1906.05776 [stat.AP], Jun. 2019.
  \url{https://arxiv.org/abs/1906.05776}.
}
