context("Fiedler matrix")

# fiedler: Fiedler Symmetric matrix ----------------------------------------------------------

test_that("Fiedler matrix has one dominant positive eigenvalue (rest negative) and symmetric", {
  A <- fiedler(10)
  eigs <- eigen(A)$values
  expect_gt(eigs[1], 0)
  expect_equal(sum(eigs[2:length(eigs)] > 0), 0)
  expect_identical(isSymmetric(A), TRUE)

  v <- rnorm(10)
  A <- fiedler(v)
  eigs <- eigen(A)$values
  expect_gt(eigs[1], 0)
  expect_equal(sum(eigs[2:length(eigs)] > 0), 0)
  expect_identical(isSymmetric(A), TRUE)
})
