% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{get_project_issues}
\alias{get_project_issues}
\title{Retrieve Highbond Project - Issues}
\usage{
get_project_issues(
  auth,
  project_id = NULL,
  issue_id = NULL,
  fields = NULL,
  pagesize = 50,
  waittime = 0.2
)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{project_id}{Required if other parameter is blank. May obtain multiple rows.}

\item{issue_id}{Required if other parameter is blank. Will get only one.}

\item{fields}{OPTIONAL. A character vector each field requested within the
project. NULL will default to all fields.}

\item{pagesize}{Defaults to 50. Maximum is 100.}

\item{waittime}{Time in seconds to wait between requests.}
}
\value{
A tibble of issues
}
\description{
"An issue is a problem, control gap, or exception that has been
identified within a project. Adding an issue involves recording basic
information about the issue and assigning the issue to an owner. Issues may
also be known as deficiencies, findings, or another customized term."
}
\details{
possible fields: title, description, creator_name, created_at,
updated_at, position, owner, recommendation, deficiency_type, severity,
published, identified_at, reference, reference_prefix, risk, scope,
escalation, cause, effect, cost_impact, executive_summary, executive_owner,
project_owner, closed, remediation_status, remediation_plan,
remediation_date, actual_remediation_date, retest_deadline_date,
actual_retest_date, retesting_results_overview, custom_attributes, project,
entities
}
