% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbts.R
\name{predict.gbts}
\alias{predict.gbts}
\title{Predict method for ensemble of Gradient Boosted Trees}
\usage{
\method{predict}{gbts}(object, x, nwrk = 2, ...)
}
\arguments{
\item{object}{a model object returned from \code{\link{gbts}}.}

\item{x}{a data.frame of predictors. It must follow the same format as the
training dataset on which the model \code{object} is developed.}

\item{nwrk}{an integer of the number of computing workers to be used. If
\code{nwrk} is less than the number of available cores on the machine, it
uses all available cores.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A numeric vector of predictions. In the case of binary classification,
predictions are probabilities.
}
\description{
This function generates predictions by weighted averaging the predictions
from each model in the ensemble returned from \code{\link{gbts}}. Weighted
average is computed on the log-odds scale for binary classification.
}
\author{
Waley W. J. Liang <\email{wliang10@gmail.com}>
}
\seealso{
\code{\link{gbts}},
         \code{\link{comperf}}
}

