% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcharts_global_areas.R
\name{gchart_countries}
\alias{gchart_countries}
\title{Extracts the list of available countries from the Google Charts documentation}
\usage{
gchart_countries(
  server = "https://developers.google.com/chart/interactive/docs/gallery/geochart",
  cache = gchart_get_cache_path(),
  format = c("rds", "rda"),
  update = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{server}{Location for the relevant Google Charts documentation.
Use the default.}

\item{cache}{Path to store downloaded data.}

\item{format}{Which format to use for storing the countries table.}

\item{update}{Whether to update the table even if it is cached.}

\item{verbose}{Whether to show messages during processing.}
}
\value{
A \code{data.frame} with information for all countries available in
the service.
}
\description{
Extracts the list of available countries from the Google Charts documentation
}
\details{
Extracts the information of countries available in the Google Charts geochart
service from the online documentation
}
