% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gdal_get_driver_md}
\alias{gdal_get_driver_md}
\title{Get metadata for a GDAL format driver}
\usage{
gdal_get_driver_md(format, mdi_name = "")
}
\arguments{
\item{format}{Character string giving a format driver short name
(e.g., \code{"GTiff"}).}

\item{mdi_name}{Optional character string giving the name of a specific
metadata item. Defaults to empty string (\code{""}) meaning fetch all metadata
items.}
}
\value{
Either a named list of metadata items and their values as character
strings, or a single character string if \code{mdi_name} is specified. Returns
\code{NULL} if no metadata items are found for the given inputs.
}
\description{
\code{gdal_get_driver_md()} returns metadata for a driver.
}
\examples{
dmd <- gdal_get_driver_md("GTiff")
str(dmd)
}
\seealso{
\code{\link[=getCreationOptions]{getCreationOptions()}}
}
