% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals-geolm.R
\name{residuals.geolm}
\alias{residuals.geolm}
\title{Extract residuals from a \code{geolm} object}
\usage{
\method{residuals}{geolm}(object, ...)
}
\arguments{
\item{object}{An object produced by the
\code{\link[gear]{geolm}} function.}

\item{...}{Not currently implemented.}
}
\value{
The vector of residuals.
}
\description{
Extract the residuals for an \code{object} produced by
 the \code{\link[gear]{geolm}}.
}
\examples{
data = data.frame(y = rnorm(10), x1 = runif(10),
                 x2 = runif(10))
d = as.matrix(dist(data[,c("x1", "x2")]))
mod = cmod_man(v = exp(-d), evar = 1)
gearmod = geolm(y ~ x1, data = data,
                coordnames = ~ x1 + x2, mod = mod)
# fitted values for original observations
residuals(gearmod)
}
\seealso{
\code{\link[stats]{residuals}}
}
\author{
Joshua French
}
