% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_db.R
\name{aggr_by_freq}
\alias{aggr_by_freq}
\title{Aggregate Data by Frequency}
\usage{
aggr_by_freq(
  table,
  freq,
  prep_fun,
  aggr_funs,
  postp_funs,
  variable_name,
  preprocess_body
)
}
\arguments{
\item{table}{[mandatory] (data.frame) A wide-format data frame.}

\item{freq}{[mandatory] (character) Specifies the frequency to aggregate the
data.}

\item{prep_fun}{[mandatory] (function) Function used for pre-processing.}

\item{aggr_funs}{[mandatory] (function or list) Aggregation function(s).}

\item{postp_funs}{[mandatory] (function or list) Post-processing function(s).}

\item{variable_name}{[mandatory] (character) Name of the current variable.}

\item{preprocess_body}{[mandatory] (character) Body of the \code{prep_fun}
function.}
}
\value{
A data frame in wide format with aggregated values.
}
\description{
Aggregates data from a wide-format data frame according to a specified
frequency and applies aggregation and post-processing functions.
}
\keyword{internal}
