% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.cv}
\alias{gelnet.cv}
\title{k-fold cross-validation for parameter tuning.}
\usage{
gelnet.cv(X, y, nL1, nL2, nFolds = 5, a = rep(1, n), d = rep(1, p),
  P = diag(p), m = rep(0, p), max.iter = 100, eps = 1e-05,
  w.init = rep(0, p), b.init = 0, fix.bias = FALSE, silent = FALSE,
  balanced = FALSE)
}
\arguments{
\item{X}{n-by-p matrix of n samples in p dimensions}

\item{y}{n-by-1 vector of response values. Must be numeric vector for regression, factor with 2 levels for binary classification, or NULL for a one-class task.}

\item{nL1}{number of values to consider for the L1-norm penalty}

\item{nL2}{number of values to consider for the L2-norm penalty}

\item{nFolds}{number of cross-validation folds (default:5)}

\item{a}{n-by-1 vector of sample weights (regression only)}

\item{d}{p-by-1 vector of feature weights}

\item{P}{p-by-p feature association penalty matrix}

\item{m}{p-by-1 vector of translation coefficients}

\item{max.iter}{maximum number of iterations}

\item{eps}{convergence precision}

\item{w.init}{initial parameter estimate for the weights}

\item{b.init}{initial parameter estimate for the bias term}

\item{fix.bias}{set to TRUE to prevent the bias term from being updated (regression only) (default: FALSE)}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}

\item{balanced}{boolean specifying whether the balanced model is being trained (binary classification only) (default: FALSE)}
}
\value{
A list with the following elements:
\describe{
  \item{l1}{the best value of the L1-norm penalty}
  \item{l2}{the best value of the L2-norm penalty}
  \item{w}{p-by-1 vector of p model weights associated with the best (l1,l2) pair.}
  \item{b}{scalar, bias term for the linear model associated with the best (l1,l2) pair. (omitted for one-class models)}
  \item{perf}{performance value associated with the best model. (Likelihood of data for one-class, AUC for binary classification, and -RMSE for regression)}
}
}
\description{
Performs k-fold cross-validation to select the best pair of the L1- and L2-norm penalty values.
}
\details{
Cross-validation is performed on a grid of parameter values. The user specifies the number of values
to consider for both the L1- and the L2-norm penalties. The L1 grid values are equally spaced on
[0, L1s], where L1s is the smallest meaningful value of the L1-norm penalty (i.e., where all the model
weights are just barely zero). The L2 grid values are on a logarithmic scale centered on 1.
}
\seealso{
\code{\link{gelnet}}
}

