% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit.boltzmann}
\alias{fit.boltzmann}
\title{Fit readings with Boltzmann model}
\usage{
fit.boltzmann(.data, A0 = 1, k0 = 1, t20 = 1)
}
\arguments{
\item{.data}{data.frame with x as time, y as value}

\item{A0}{initial guess of amplititue, default 1}

\item{k0}{initial guess, default 1}

\item{t20}{initial guess, default 1}
}
\value{
data.frame with fitted parameter and predicted value
}
\description{
fit.boltzmann() using Boltzmann model to fit readings and time intervals with
unit of hours, using start as initial guesses. It appends A, y0, k, t2 and val.predict, while preserving existing
variables.
}
\examples{
fit.boltzmann(data.frame(x=1:10,y=c(0,0,1,3,5,7,9,10,10,10)), A0 = 10, k0 = 10, t20 = 5)

}
