% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dpmmDistance}
\alias{dpmmDistance}
\title{DPMM Distance}
\usage{
dpmmDistance(x, y)
}
\arguments{
\item{x}{List with elements 'Zscore' and 'Adj'}

\item{y}{List with elements 'Zscore' and 'Adj', both of same dimensions as in x.}
}
\value{
Numeric, DPMM distance between x and y.
}
\description{
For an MCMC draw from a DPMM D_x, let Z_x be the vector of Z-scores of the
observations based on that observation's current group, and let A_x be the
0,1 adjacency matrix where \deqn{[A_x]_{ij} = 1} if observations i and j are in
the same group in draw D_x (so the diagonal is always 1s).
Then we define the DPMM distance between D_x and D_y as: \deqn{
   d(D_x, D_y) = |Z_x - Z_y|^T(|A_x - A_y| + I)|Z_x - Z_y|.
}
}
\note{
For speed, no error handling if x and y do not have the same dimensions. The function
will break if 'Zscore' or 'Adj' doesn't exist though.
}
