% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SEIQRDP.R
\name{plot_SEIQRDP}
\alias{plot_SEIQRDP}
\title{Plots for Epidemic Curves}
\usage{
plot_SEIQRDP(
  object,
  reported = TRUE,
  sep = FALSE,
  show = c("S", "E", "I", "Q", "R", "D", "P"),
  ci = FALSE,
  title = NULL,
  checkRates = FALSE,
  ...
)
}
\arguments{
\item{object}{a predict_SEIQRDP result.}

\item{reported}{a logical argument. If \code{TRUE} reported official cases will be added to the plot.}

\item{sep}{a logical argument. If \code{TRUE} seperate plots will be plotted. If \code{FALSE} one plot with all desired states will be plotted.}

\item{show}{select one or more desired state. \code{S}: Susceptible, \code{E}: Exposed, \code{I}: Infectious, \code{Q}: Quarantined, \code{R}: Recovered, \code{D}: Dead, \code{P}: Insusceptible}

\item{ci}{a logical argument. If \code{TRUE} a bootstrap confidence intetval will be added to the plot.}

\item{title}{an optional title for the plot.}

\item{checkRates}{if \code{TRUE} compares the fitted and calcualted death and recovered ratios through plots}

\item{...}{other plot options}
}
\value{
plots for epidemic curves: active cases, recovered and deaths
}
\description{
This function creates plots for reported and predicted active, recovered and death cases.
}
\examples{
\donttest{
 alpha_guess = 0.45
 beta_guess = 1
 LT_guess = 2
 Q_guess = 0.55
 lambda_guess = c(0.01,0.01,30)
 kappa_guess = c(0.01,0.001,30)

 guess = list(alpha_guess,
              beta_guess,
              1/LT_guess,
              Q_guess,
              lambda_guess[1],
              lambda_guess[2],
              lambda_guess[3],
              kappa_guess[1],
              kappa_guess[2],
              kappa_guess[3])

 pred = predict_SEIQRDP(country = "Germany", start = "10/15/20", finish = "12/15/20",
                        dt = 1, f = 30, conf = 0.95, Npop = 80000000, guess, boot = TRUE,
                        seed = 123, repeatNumber = 10, bootSample = NULL, type = "norm")


 plot_SEIQRDP(object = pred, sep = FALSE, ci = TRUE, show = c("Q", "R", "D"), checkRates = TRUE)


}

}
\seealso{
\code{\link{SEIQRDP}} \code{\link{fit_SEIQRDP}}
}
\author{
Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}

Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}
}
