% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{rhypersphere}
\alias{rhypersphere}
\title{Hypersphere}
\usage{
rhypersphere(n, dim = 2, radius = 1, center = rep(0, dim), type = "boundary")
}
\arguments{
\item{n}{number of observations to simulate.}

\item{dim}{dimensions of hypersphere.}

\item{radius}{radius of hypersphere.}

\item{center}{center of hypersphere.}

\item{type}{character; if \code{"boundary"} (default) then random variates 
are simulated from the hypersphere. If \code{"inside"} random
variates are points lying inside the hypersphere. If \code{"non-uniform"} 
then random variates are non-uniform and simulated from the inner part
of the hypersphere simply by making radius a uniform random variable
between \code{0} and \code{radius}.}
}
\value{
The function returns a vector of random variates.
}
\description{
Simulates uniform random variates from the hypersphere.
}
\examples{
set.seed(123)
# Get 5 random uniform variates from 3D hypersphere
# of radius 10 centered at (2, 3, 1)
rhypersphere(n = 5, dim = 3, radius = 10, center = c(2, 3, 1))

}
