% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genodds.R
\name{genodds}
\alias{genodds}
\alias{print.Genodds}
\title{Generalized Odds Ratios}
\usage{
genodds(response, group, strata=NULL,
        alpha=0.05,ties="split",
        nnt=FALSE,verbose=FALSE,upper=TRUE, suppress_interpretation=FALSE,
        assume_no_effect=FALSE,
        permutation_test=FALSE, nPermutations=5000)
}
\arguments{
\item{response}{A (non-empty) vector. Gives the outcome measure.
If a factor, level order is used to determine ranking of outcomes.}

\item{group}{A factor vector of equal length to \code{response}.
Gives the groups for the test. Must take on exactly 2 values.}

\item{strata}{An optional factor vector of equal length to \code{response}.
Gives treatment blocks to separate comparisons.}

\item{alpha}{The acceptable type 1 error used in the test.}

\item{ties}{A string specifying how ties should be treated.
Should be equal to "split" 0.5 for WMW Odds,
or "drop" for Agresti's GenOR.}

\item{nnt}{A boolean.
If \code{TRUE}, then print number needed to treat in addition to generalised odds ratios.}

\item{verbose}{A boolean.
If \code{TRUE}, then print both pooled odds and relative risk ratio matrices
regardless of result of statistical test.}

\item{upper}{A boolean specifying if the upper triangle
of relative risk ratios should be printed.
If \code{FALSE}, lower triangle is used instead.}

\item{suppress_interpretation}{A boolean specifying if the interpretable summary statements of results should be suppressed.}

\item{assume_no_effect}{A boolean indicating if p-values and confidence intervals should be calculated
using pooled_SElnnull (if TRUE) or pooled_SElnodds (if FALSE).}

\item{permutation_test}{A boolean specifying if a permutation test should be performed on the data}

\item{nPermutations}{The number of permutations to use in the permutation test}
}
\value{
A list with class "\code{Genodds}" containing the following:
\describe{
    \item{pooled_lnodds}{The pooled log(odds).}
    \item{pooled_lnconf.int}{(1-\code{alpha})\% Confidence intervals for pooled log(odds).}
    \item{pooled_SElnodds}{Standard error of pooled log(odds).}
    \item{pooled_SElnnull}{Standard error of pooled log(odds) under the null hypothesis.}
    \item{pooled_p}{The p-value of the test of pooled log(odds) = 1.}
    \item{pooled_rel_statistic}{Statistic of test that strata odds are equal.}
    \item{pooled_rel_p}{p-value for test that strata odds are equal.}
    \item{relative_lnodds}{A matrix giving the log of the ratio of odds between strata (generalised relative risk ratio).}
    \item{relative_selnodds}{A matrix containing the standard error of the log(relative risk ratio).}
    \item{results}{A list containing a summary of each strata measure.}
    \item{param.record}{A list containing parameters used in the test.}
}
}
\description{
Performs Agresti's Generalized Odds Ratios (GenOR) for two-group ordinal data.
}
\details{
Agresti's generalized odds ratios (GenOR) calculates the odds that,
if a pair of observations are randomly selected from
two groups, the outcome in one group is higher than the other.
This implementation determines the direction of this comparison
using factor levels. Odds are given with reference to
observations corresponding to the higher \code{group} level
resulting in a higher value in \code{response}.
The opposite direction can be calculated by either calculating 1/genodds,
or by specifying \code{response=1-response} in function input.

If \code{nnt=TRUE}, the Number Needed to Treat (NNT) is printed.
NNT is a health economics measure and is related to generalised
odds ratios through the formula NNT=1+2/(GenOR-1).
It measures the expected number of patients required for a
treatment to have impacted a patient's outcome.
In this implementation, a positive NNT occurs when GenOR>1
and corresponds to the number needed to treat in the higher
\code{group} level to observe a higher \code{response} value,
while a negative NNT occurs when GenOR<1 and corresponds
to the number needed to treat in the higher \code{group}
level to observe a lower \code{response} value.
If the confidence interval for GenOR straddles 1,
the confidence interval for NNT is given as the union of disjoint
intervals.

\code{ties} changes how ties are treated. If \code{"split"} is provided,
then ties are equally split between favouring both groups
(following the approach set out by O'Brien et. al. (2006)).
If \code{"drop"} is provided, then ties are ignored
(following the approach set out by Agresti (1980)).
By default, \code{"split"} is used.

If \code{assume_no_effect==TRUE}, use O'Brien's method for calculating standard
error under null for the purposes of calculating p-values and confidence intervals.
If \code{assume_no_effect==FALSE} (the default option), then p-values and confidence intervals
will be calculated using standard error instead.

If \code{strata} is specified, generalized odds ratios are calculated
separately for each individual strata. If in-stratum odds ratios are not
significantly different from each other (with significance level \code{alpha}),
these odds are pooled to obtain a global odds ratio which is adjusted
for strata. If in-stratum odds ratios are significantly different, a matrix containing
the relative risk ratios between stratum is printed, along with Z-scores
corresponding to the significance of these differences.
If \code{verbose=TRUE} is supplied, both pooled odds and relative risk ratios
are printed regardless of if the between-stratum odds ratios are
significantly different.

Permutation testing is performed following the approach suggested by Howard et al. (2012),
where the probability of a random observation from one group achieving a higher score
than a patient in another group is calculated (given there is a difference between the scores),
and then the \code{group} labels are randomly shuffled to guarantee the null hypothesis
of no difference between groups is true. The permutation test p-value is the proportion of such
permutations which result in a test statistic more extreme than what was observed on the original
data, forming a two-tail test. This procedure is equivalent to that provided by Agresti's generalised
odds ratio, and is implemented here for both methods of handling \code{ties}.

By default, \code{print.genodds()} will report an interpretable summary of the test statistic
following a loosely modified form of the statements suggested by Howard et al. (2012).
This may be suppressed by specifying \code{suppress_interpretation=TRUE}.

Options \code{verbose}, \code{nnt}, \code{upper}, and \code{suppress_interpretation}
may be re-specified when using print method.
}
\examples{
# Use the alteplase dataset provided by package and calculate genodds
df <- alteplase
x <- genodds(df$mRS,df$treat,df$time)
x
print(x,nnt=TRUE)

}
\references{
Agresti, A. (1980). Generalized odds ratios for ordinal data.
\emph{Biometrics}, 59-67.

O'Brien, R. G., & Castelloe, J. (2006, March).
Exploiting the link between the Wilcoxon-Mann-Whitney test and a simple odds statistic.
In \emph{Thirty-first Annual SAS Users Group International Conference}.

Churilov, L., Arnup, S., Johns, H., Leung, T., Roberts,
S., Campbell, B. C., Davis, S. M. & Donnan, G. A. (2014).
An improved method for simple, assumption-free ordinal analysis of the
modified Rankin Scale using generalized odds ratios.
\emph{International Journal of Stroke}, 9(8), 999-1005.

Howard, G., Waller, J. L., Voeks, J. H., Howard, V. J., Jauch, E. C.,
Lees, K. R., ... & Hess, D. C. (2012). A simple, assumption-free,
and clinically interpretable approach for analysis of modified Rankin
outcomes. \emph{Stroke}, 43(3), 664-669.
}
