% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{climate}
\alias{climate}
\title{climate}
\format{
climate data refers to the younger emplyees (<=30) of an international bank organizational study. It
consists of 32 variables for 669 employees divided into 3 qualitative variables and 29 indicator (or manifest)
variables. The 3 categorical variables, reflecting specific employee characteristics
as potential observed sources of heterogeneity, gender, job level,
and seniority. The 31 indicator (or manifest)
variables were loyalty (3 indicators), satisfaction (6 indicators),
and the 5 work climate constructs of empowerment (5 indicators),
company reputation (3 indicators), pay (4 indicators), work conditions (3 indicators),
leadership (5 indicators)


Latent variable description
\describe{
     \item{\code{Loyalty}: }{Employee commitment to the organization}
     \item{\code{Satisfaction}: }{Employee contentedness with their job and aspects such as kind of work, supervision, etc}
     \item{\code{Empowerment}: }{Employee perceptions of management vision (vertical or horizontal)}
     \item{\code{Reputation}: }{Employee perceptions of the company’s reputation}
     \item{\code{Leadership}: }{Employee perceptions of leadership practices such as feedback and appraisal}
     \item{\code{Pay}: }{Employee perceptions of pay and of its equity}
     \item{\code{Conditions}: }{Employee perceptions regarding the conditions in which they perform their work}
}

Manifest variables description
\describe{
\item{\code{Emp1}: }{Employee treatment as responsible}
\item{\code{Emp2}: }{Teamwork is empowered}
\item{\code{Emp3}: }{Autonomy is favored}
\item{\code{Emp4}: }{Confidence in performed tasks}
\item{\code{Emp5}: }{Creativity and initiative are endorsed}
\item{\code{Imag1}: }{Organization’s reputation}
\item{\code{Imag2}: }{Organization’s values}
\item{\code{Imag3}: }{Organization’s customer relationships}
\item{\code{Pay1}: }{Salary}
\item{\code{Pay2}: }{Social benefits}
\item{\code{Pay3}: }{My salary corresponds to my duties}
\item{\code{Pay4}: }{My salary corresponds to my effort}
\item{\code{Work1}: }{Enough personnel in the office}
\item{\code{Work2}: }{Enough time to perform the tasks}
\item{\code{Work3}: }{Conditions and tools for work}
\item{\code{Lead1}: }{Agenda and planning}
\item{\code{Lead2}: }{Receptiveness}
\item{\code{Lead3}: }{Encouraging}
\item{\code{Lead4}: }{Communication}
\item{\code{Lead5}: }{Celebrating success}
\item{\code{Sat1}: }{Overall rating of satisfaction}
\item{\code{Sat2}: }{Tasks in accordance with capabilities}
\item{\code{Sat3}: }{Possibility to know efficiency}
\item{\code{Sat4}: }{Possibility to learn new things}
\item{\code{Sat5}: }{Usefulness of performed job}
\item{\code{Sat6}: }{Fulfilment of expectations}
\item{\code{Loy1}: }{I am unwilling to leave in case of not finding alternative}
\item{\code{Loy2}: }{I am committed to the institution}
\item{\code{Loy3}: }{I trust in the proper direction of the management}
}

Segmentation variables description
\describe{
\item{\code{Gender}: }{Gender of the employees, a factor with levels: \code{male} and \code{female}}
\item{\code{Level}: }{Level of the employees, a factor with levels: \code{low}, \code{medium}, and \code{high}}
\item{\code{Seniority}: }{Time working in the bank, a factor with levels: \code{<5y} and \code{15-5y}}
}
}
\usage{
climate
}
\description{
climate
}
\references{
Lamberti, G., Aluja Banet, T., & Rialp Criado, J. (2020).
Work climate drivers and employee heterogeneity.
\emph{The International Journal of Human Resource Management}, 1-33.
doi: 10.1080/09585192.2020.1711798.

Lamberti, G. (2021). Hybrid multigroup partial least squares structural equation
 modelling: an application to bank employee satisfaction and loyalty. \emph{Quality and Quantity},
 doi: 10.1007/s11135-021-01096-9.
}
\keyword{datasets}
